/////////////////////////////////////////////////////////////
//	File	:	"CNote.cpp"
//
//	Author	:	Alyssa Dettling (AD)
//
//	Purpose	:	Defines a note object for the game
/////////////////////////////////////////////////////////////

#include "CNote.h"
#include "CSGD_TextureManager.h"
#include "CSGD_EventSystem.h"
#include "CSGD_MessageSystem.h"
#include "CNoteManager.h"
#include <math.h>

//////////////////////////////////////////////////////////////////////////////////
//  Function: Constructor
//
//  Purpose : Initializes the data in the object.
///////////////////////////////////////////////////////////////////////////////////
CNote::CNote(void) : CBase()
{
	m_nNoteType = QUARTER_NOTE;
	m_bIsHit = false;
	m_nSin = 0.0f;
	startYPos = 0.0f;
	m_nGoodDeadID = CSGD_TextureManager::GetInstance()->LoadTexture("Resources/Good_Sad2.png");
	m_nBadDeadID = CSGD_TextureManager::GetInstance()->LoadTexture("Resources/Bad_Dead2.png");
	
}

///////////////////////////////////////////////////////////////////////////////////
//  Function: Destructor
//
//  Purpose : Cleans up any dynamic memory.
///////////////////////////////////////////////////////////////////////////////////
CNote::~CNote(void)
{
	CBase::~CBase();
}

///////////////////////////////////////////////////////////////////////////////
//	Function:	"Update"
//
//	Purpose:	Updates the objects position based on its velocity
///////////////////////////////////////////////////////////////////////////////
void CNote::Update(float fElapsedTime)
{
	SetPosX( GetPosX() + (GetVelX() * fElapsedTime));	//	Update X position
	SetPosY( GetPosY() + (GetVelY() * fElapsedTime));	//	Update Y position

	if(CBase::GetPosX() < 110)
	{
		CSGD_MessageSystem::GetInstance()->SendMsg(new CDestroyNoteMessage(this));
		CNoteManager::GetInstance()->AddNote(this);
		if(GetType() == OBJECT_BAD_NOTE && !m_bIsHit)
			CSGD_EventSystem::GetInstance()->SendEvent("BadNoteMissed", this);

		m_bIsHit = true;
	}

	if(CBase::GetPosY() > 700)
	{
		CSGD_MessageSystem::GetInstance()->SendMsg(new CDestroyNoteMessage(this));
		CNoteManager::GetInstance()->AddNote(this);
	}

	m_rCollisionRect.right = (long)(GetPosX() + 47);
	m_rCollisionRect.bottom = (long)(GetPosY() + 62);
	m_rCollisionRect.top = (long)GetPosY();
	m_rCollisionRect.left = (long)GetPosX();

	if(m_bIsHit)
	{
		if(GetType() == OBJECT_BAD_NOTE)
			m_nImageID = m_nBadDeadID;
		else if(GetType() == OBJECT_GOOD_NOTE)
			m_nImageID = m_nGoodDeadID;

		SetRotation(GetRotation() + 3*fElapsedTime);
	{
		SetRotation(GetRotation() + 2 * fElapsedTime);
		SetVelY(GetVelY() + 1);
		SetVelX(0);
	}
	}
	else
	{
		float result = sin(3*m_nSin);// + cos(2*m_nSin);

		SetPosY(startYPos + result * 20.0f);

		m_nSin += 0.01f;
	}
}

///////////////////////////////////////////////////////////////////////////////
//	Function:	Render
//
//	Purpose:	Renders the object
///////////////////////////////////////////////////////////////////////////////
void CNote::Render(void)
{
	// uncomment to show collision rects
	//CBase::Render();	
	CSGD_TextureManager::GetInstance()->DrawTexture(m_nImageID, GetPosX(), GetPosY(), 0.3f, GetScale(), GetScale(), 0, GetWidth()/2.0f, GetHeight()/2.0f, GetRotation());		//	Render the object based on its position
}

///////////////////////////////////////////////////////////////////////////////
//	Function:	CheckCollisions
//
//	Purpose:	Checked collisions on this object against every other object.
///////////////////////////////////////////////////////////////////////////////
bool CNote::CheckCollisions(CBase * pBase) 
{
	RECT tempRect;

	if(pBase->GetType() == CBase::OBJECT_SOUND_WAVE && this != pBase)
	{
		
		if(!m_bIsHit && IntersectRect(&tempRect, &GetCollisionRect(), &pBase->GetCollisionRect()))
		{
			m_bIsHit = true;
			SetVelY(50);
			if(GetType() == OBJECT_GOOD_NOTE)
				CSGD_EventSystem::GetInstance()->SendEvent("GoodNoteHit", this);
			else if(GetType() == OBJECT_BAD_NOTE)
				CSGD_EventSystem::GetInstance()->SendEvent("BadNoteHit", this);

			CSGD_MessageSystem::GetInstance()->SendMsg(new CDestroyBulletMessage(pBase));

			return true;
		}
		
	}

	return false; 
}


void CNote::HandleEvent(CEvent* pEvent)
{
}
